import refreshTokenHelper from "../../../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../../../utils/errorHandlingHelper"
import fetchHelper from "../../../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  let newObjValue = {}
  if(body.uomId) {
    newObjValue = {...newObjValue, 
      C_UOM_ID: {
        id: body.uomId,
        tableName: 'C_UOM'
      }
    }
  }
  if(body.currencyId) {
    newObjValue = {...newObjValue, 
      C_Currency_ID: {
        id: body.currencyId,
        tableName: 'C_Currency'
      }
    }
  }

  if(body.id) {
    const res: any = await fetchHelper(event, 'models/m_product_po/'+body.id, 'PUT', token, {
      isActive: body.isActive,
      vendorProductNo: body.vendorProductNo,
      vendorCategory: body.vendorCategory,
      priceEffective: body.priceEffective,
      manufacturer: body.manufacturer,
      discontinued: body.discontinued,
      priceList: body.priceList,
      priceLastPO: body.priceLastPO,
      Order_Min: body.orderMin,
      Order_Pack: body.orderPack,
      pricePO: body.pricePO,
      isCurrentVendor: body.isCurrentVendor,
      qualityRating: body.qualityRating,
      DeliveryTime_Promised: body.deliveryTimePromised,
      DeliveryTime_Actual: body.deliveryTimeActual,
      costPerOrder: body.costPerOrder,
      priceLastInv: body.priceLastInv,
      royaltyAmt: body.royaltyAmt,
      UPC: body.upc,
      ...newObjValue,
      tableName: 'm_product_po'
    })
    if(res) {
      data = res
      data['status'] = 200
      data['message'] = ''
    }
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})